###############################################################################
# PasswordRBL.com 
# Password Permutation Generator
# Version 2.00
#
# Additional documentation at www.PasswordRBL.com
# Use of this file is limited to active subscribers only.
# 
# This code is licensed as "source-available."  You can view the source code
# but end-user cannot redistribute derivitive works and no warranty is provided
#
###############################################################################

Param(
    [parameter(Mandatory=$true)]
    [ValidateNotNullOrEmpty()]
    [String] $Mode,

    [parameter(Mandatory=$true)]
    [ValidateNotNullOrEmpty()]
    [String] $InputString    
)


function PrintUsage() {
   Write-Host "`nUSAGE: `n";
   Write-Host "prbl-PermutationGenerator.ps1 <Required Parameters>`n";
   Write-Host "REQUIRED PARAMETERS:`n";
   Write-Host "   -Mode must be defined as one of the following:";
   Write-Host "`tAutomatic:  Automatically creates permutations.";
   Write-Host "`tManual:     Specify character options for each position.`n";
   Write-Host "   -InputString is string that is seed for permutation generation,  The format is different per Mode.";
   Write-Host "`tAutomatic:  A single permutation of the password to block.";
   Write-Host "`tManual:     A comma-delimited string of character options for each position.`n`n";
   Write-Host "See: https://www.passwordrbl.com for additional usage information.`n`n";
}


# Change to unicode UTF8 encoding
chcp 65001 | out-null;



###############################################################################
# Start of main
###############################################################################


Write-Host "`n**************************************************************";
Write-Host "* Password RBL - Permutation Generator - v2.00               *";
Write-Host "*                                                            *";
Write-Host "* Use this utility to create all character permutations of a *";
Write-Host "* password.  For use with CBL-Management utility.            *";
Write-Host "*                                                            *";
Write-Host "* Copyright (c) 2019 - Password RBL                          *";
Write-Host "**************************************************************`n";

#$starttime = Get-Date;
#$Time = [System.Diagnostics.Stopwatch]::StartNew();

#Allow for shorthand abbreviations
if ($Mode -like "man*") { $Mode = "Manual" };
if ($Mode -like "auto*") { $Mode = "Automatic" }; 

switch ( $Mode ) {
   "Manual" {
      Write-Host "Manual Mode`n";
      $aos = $InputString -split ',';
   }

   "Automatic" {
      Write-Host "Automatic Mode`n";
      [String[]]$aos = new-object String[] $InputString.length;

      for ($i=0; $i -lt $InputString.length; $i++) {

         $curChar = $InputString.substring($i, 1);
         $aos[$i] += -join( $curChar );
         if ( $curChar.ToUpper() -cne $curChar ) {  $aos[$i] += -join( $curChar.ToUpper() );  }
         if ( $curChar.ToLower() -cne $curChar ) {  $aos[$i] += -join( $curChar.ToLower() );  }
 
         switch ($curChar) {
            "a" { $aos[$i] += -join( '@4' ); }
            "b" { $aos[$i] += -join( '8' ); }
            "c" { $aos[$i] += -join( '(' ); }
            "d" { $aos[$i] += -join( '6' ); }
            "e" { $aos[$i] += -join( '3' ); }
            "f" { $aos[$i] += -join( ''); }
            "g" { $aos[$i] += -join( ''); }
            "h" { $aos[$i] += -join( ''); }
            "i" { $aos[$i] += -join( '!1' ); }
            "j" { $aos[$i] += -join( ''); }
            "k" { $aos[$i] += -join( ''); }
            "l" { $aos[$i] += -join( '1' ); }
            "m" { $aos[$i] += -join( ''); }
            "n" { $aos[$i] += -join( ''); }
            "o" { $aos[$i] += -join( '0' ); }
            "p" { $aos[$i] += -join( ''); }
            "q" { $aos[$i] += -join( ''); }
            "r" { $aos[$i] += -join( ''); }
            "s" { $aos[$i] += -join( '$5' ); }
            "t" { $aos[$i] += -join( '7+' ); }
            "u" { $aos[$i] += -join( ''); }
            "v" { $aos[$i] += -join( ''); }
            "w" { $aos[$i] += -join( ''); }
            "x" { $aos[$i] += -join( '%' ); }
            "y" { $aos[$i] += -join( ''); }
            "z" { $aos[$i] += -join( ''); }
         }#switch-curChar
      }#for-inputstring
   }#switch-Automatic

   default {
      Write-Host -Foreground Red -Background Black "`n`nERROR: MODE must be Automatic or Manual.`n`n";
      PrintUsage;
      exit -1;
   }

}#switch



Write-Host "Character sets used in Permutation Generation:";
for ($i=0; $i -lt $aos.length; $i++) {
   Write-Host -NoNewLine -Separator '' "[", $aos[$i], "] ";
}
Write-Host "`n";


$aoslen = $aos.length;
[int[]]$sizeArr = new-object int[] $aoslen;
[int[]]$indexArr = new-object int[] $aoslen;

# create array of inner member sizes and calculate total expected permutations
# index array is initialized to zeros
$totalPerms = 1;
for ($i=0; $i -lt $aoslen; ++$i) {
   $sizeArr[$i] = $aos[$i].length;
   $totalPerms *= $aos[$i].length;
}
Write-Host "Total Permutations to Create: $totalPerms";
Write-Host -NoNewLine "`nCreating Permutations...";

# create permutations
for ($cntdwn = $totalPerms; $cntdwn -gt 0; --$cntdwn) {
   $curPerm = "";

   # run through outer array, get 1 char from index of each inner member
   for ($i = 0; $i -lt $aoslen; ++$i) {
      $curPerm += -join( $aos[$i].substring($indexArr[$i],1) );
   }
   Write-Output $curPerm;

   # update index counter array with new counter value(s)
   for ($j = ($aoslen-1); $j -ge 0; --$j ) {
      if ( ($indexArr[$j]+1) -lt $sizeArr[$j] ) {
         ++$indexArr[$j];
         # this case is not a wraparound, so break from loop
         break;
      }#if
      # wraparound
      # The index at this position hit its max value, so zero it 
      # and continue the loop to increment the next most significant index
      $indexArr[$j] = 0;
   }#for-index-update

   if (($cntdwn % 500) -eq 0) {
      Write-Progress -Activity "Creating Permutations" -Status "Progress:" -PercentComplete ((($totalPerms-$cntdwn)/$totalPerms)*100)
   }
}#permutations

Write-Host "Complete`n";

#eof